/**
* \file: am_api_control.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include "am_api_control.h"

#include "ipc/request_messages.h"
#include "ipc/info_messages.h"
#include "ipc/message_sendr.h"
#include "ipc/message_recvr.h"
#include "utils/logger.h"
#include "am_api_socket_client.h"
#include "am_api_events.h"

//------------------------------------- public member definition ------------------------------------------------------
error_code_t am_api_control_remount_partition_by_mountpoint(const char *mountpoint,const char *options,
		int request_id, request_done_callback_t done_callback_func)
{
	error_code_t result;
	message_buffer_t *msg_buffer=message_sendr_get_empty_buffer();
	result=request_message_prepare_remount_request_msg(msg_buffer, mountpoint,options,ID_TYPE_MOUNTPOINT,
			request_id,done_callback_func);
	if (result==RESULT_OK)
		result=am_api_socket_client_send_message(msg_buffer);
	else
		message_sendr_putback_buffer(msg_buffer);

	return result;
}

error_code_t am_api_control_remount_partition_by_id(const char *partition_id,const char *options,
		int request_id, request_done_callback_t done_callback_func)
{
	error_code_t result;
	message_buffer_t *msg_buffer=message_sendr_get_empty_buffer();
	result=request_message_prepare_remount_request_msg(msg_buffer, partition_id,options,ID_TYPE_PARTITION_ID,
			request_id,done_callback_func);
	if (result==RESULT_OK)
		result=am_api_socket_client_send_message(msg_buffer);
	else
		message_sendr_putback_buffer(msg_buffer);
	return result;
}

error_code_t am_api_control_umount_device(const char *device_id,
		int request_id, request_done_callback_t done_callback_func)
{
	error_code_t result;
	message_buffer_t *msg_buffer=message_sendr_get_empty_buffer();
	result=request_message_prepare_umount_request_msg(msg_buffer, device_id,ID_TYPE_DEVICE_ID,request_id,done_callback_func);
	if (result==RESULT_OK)
		result=am_api_socket_client_send_message(msg_buffer);
	else
		message_sendr_putback_buffer(msg_buffer);
	return result;
}

error_code_t am_api_control_umount_partition_by_id(const char *partition_id,
		int request_id, request_done_callback_t done_callback_func)
{
	error_code_t result;
	message_buffer_t *msg_buffer=message_sendr_get_empty_buffer();
	result=request_message_prepare_umount_request_msg(msg_buffer, partition_id,ID_TYPE_PARTITION_ID,request_id,done_callback_func);
	if (result==RESULT_OK)
		result=am_api_socket_client_send_message(msg_buffer);
	else
		message_sendr_putback_buffer(msg_buffer);
	return result;
}

error_code_t am_api_control_umount_partition_by_mountpoint(const char *mount_point,
		int request_id, request_done_callback_t done_callback_func)
{
	error_code_t result;
	message_buffer_t *msg_buffer=message_sendr_get_empty_buffer();
	result=request_message_prepare_umount_request_msg(msg_buffer,mount_point,ID_TYPE_MOUNTPOINT,request_id,done_callback_func);
	if (result==RESULT_OK)
		result=am_api_socket_client_send_message(msg_buffer);
	else
		message_sendr_putback_buffer(msg_buffer);
	return result;
}

error_code_t am_api_control_get_snapshot(snapshot_scope_t scope, int request_id)
{
	error_code_t result;
	message_buffer_t *msg_buffer=message_sendr_get_empty_buffer();
	result=request_message_prepare_snapshot_request_msg(msg_buffer, scope,request_id);
	if (result==RESULT_OK)
		result=am_api_socket_client_send_message(msg_buffer);
	else
		message_sendr_putback_buffer(msg_buffer);
	return result;
}

void am_api_control_send_application_info(const char *app_info, event_mask_t event_mask)
{
	error_code_t result;
	message_buffer_t *msg_buffer=message_sendr_get_empty_buffer();
	logger_log_debug("AUTOMOUNTER_API - Sending application info to the automounter daemon.");
	result=request_message_prepare_appinfo_msg(msg_buffer, app_info, event_mask);
	if (result==RESULT_OK)
		result=am_api_socket_client_send_message(msg_buffer);
	else
		message_sendr_putback_buffer(msg_buffer);

	if (result!=RESULT_OK)
		logger_log_error("AUTOMOUNTER_API - Unable to send application info to the automounter daemon.");
}
//---------------------------------------------------------------------------------------------------------------------
